<?php
require("dbconnection.php");

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['asubmit'])) {
    // Get the form data using POST
    $department = mysqli_real_escape_string($conn, $_POST['department']);
    $doctor = mysqli_real_escape_string($conn, $_POST['doctor']);
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $email = mysqli_real_escape_string($conn, $_POST['email']);
    $appointment_date = mysqli_real_escape_string($conn, $_POST['appointment_date']);
    $appointment_time = mysqli_real_escape_string($conn, $_POST['appointment_time']);

    // Using prepared statements to prevent SQL injection
    $sql ="INSERT INTO appointments (department, doctor, name, email, appointment_date, appointment_time) VALUES ('$department', '$doctor', '$name', '$email', '$appointment_date', '$appointment_time')";

    // Execute the prepared statement
    if (mysqli_query($conn, $sql)) {
        echo "<script>alert('Appointment booked successfully!');</script>";
    } else {
        echo "Error: " . $sql . "<br>" . mysqli_error($conn);
    }

    // Close the statement and database connection
    mysqli_close($conn);
}
?>



<!-- Appointment Start -->
<div class="container-fluid bg-primary my-5 py-5">
    <div class="container py-5">
        <div class="row gx-5">
            <div class="col-lg-6 mb-5 mb-lg-0">
                <div class="mb-4">
                    <h5 class="d-inline-block text-white text-uppercase border-bottom border-5">Need Emergency</h5>
                    <h1 class="display-4">Request For Appoinment</h1>
                </div>
                <p class="text-white mb-5">At Life Care Hospital, we are dedicated to providing compassionate and exceptional healthcare to our community. Our team of experienced medical professionals is committed to offering the highest standards of patient care with a focus on safety, quality, and innovation.</p>
                <a class="btn btn-dark rounded-pill py-3 px-5 me-3" href="doctors.php">Find A Doctor</a>
                <a class="btn btn-outline-dark rounded-pill py-3 px-5" href="departments.php">Read More</a>
            </div>
            <div class="col-lg-6">
                <div class="bg-white text-center rounded p-5">
                    <h1 class="mb-4">Book An Appointment</h1>
                    <form method="POST" action="index.php">
                        <div class="row g-3">
                            <div class="col-12 col-sm-6">
                                <select class="form-select bg-light border-0" name="department" style="height: 55px;">
                                    <option selected>Choose Department</option>
                                    <option value="Cardiology">Cardiology</option>
                                    <option value="Neuro Surgeon">Neuro Surgeon</option>
                                    <option value="Neuro Medicine">Neuro Medicine</option>
                                    <option value="General Medicine">General Medicine</option>
                                    <option value="Nephrology">Nephrology</option>
                                    <option value="Gynaecology">Gynaecology</option>
                                    <option value="General Surgery">General Surgery</option>
                                    <option value="Orthopedics">Orthopedics</option>
                                    <option value="Pediatric Neonatology">Pediatric Neonatology</option>
                                    <option value="Pediatric Surgery">Pediatric Surgery</option>
                                    <option value="Psychiatry">Psychiatry</option>
                                    <option value="Clinical Psychology">Clinical Psychology</option>
                                    <option value="Plastic Surgery">Plastic Surgery</option>
                                    <option value="Pulmonology">Pulmonology</option>
                                    <option value="Onchology">Onchology & Oncho Surgery</option>
                                    <option value="Urology">Urology</option>
                                    <option value="ENT">ENT</option>
                                    <option value="Dental">Dental</option>
                                    <option value="Dermatology">Dermatology</option>
                                    <option value="Reumatology">Reumatology</option>
                                    <option value="Radiology">Radiology</option>
                                    <option value="Microbiology">Microbiology</option>
                                    <option value="Pathology">Pathology</option>
                                    <option value="Eye">Eye</option>
                                </select>
                            </div>
                            <div class="col-12 col-sm-6">
                                <select class="form-select bg-light border-0" name="doctor" style="height: 55px;">
                                    <option selected>Select Doctor</option>
                                    <option value="Dr.Arnab Ghosh Chowdhuru">Dr.Arnab Ghosh Chowdhuru</option>
                                    <option value="Dr.Radha Binod Paul">Dr.Radha Binod Paul</option>
                                    <option value="Dr.Arun Agarwal">Dr.Arun Agarwal</option>
                                    <option value="Dr.Debasmita Roy">Dr.Debasmita Roy</option>
                                    <option value="Dr.Srijit Chatterjee">Dr.Srijit Chatterjee</option>
                                    <option value="Dr.Arun Agarwal">Dr.Arun Agarwal</option>
                                    <option value="Dr.Sanjoy Sen">Dr.Sanjoy Sen</option>
                                    <option value="Dr.Syeda Azra Zabin">Dr.Syeda Azra Zabin</option>
                                    <option value="Dr.Jiban Krishna Chatterjee">Dr.Jiban Krishna Chatterjee</option>
                                    <option value="Dr.Partha Karmakar">Dr.Partha Karmakar</option>
                                    <option value="Dr.Aniruddha Rudra">Dr.Aniruddha Rudra</option>
                                    <option value="Dr.Isha Sudrania">Dr.Isha Sudrania</option>
                                    <option value="Dr.Niladri Sen">Dr.Niladri Sen</option>
                                    <option value="Dr.Indranil Dutta">Dr.Indranil Dutta</option>
                                    <option value="Dr.Chandan Sen">Dr.Chandan Sen</option>
                                    <option value="Dr.Ranita Saha">Dr.Ranita Saha</option>
                                    <option value="Dr.Sabyasachi(Raja) Majumder">Dr.Sabyasachi(Raja) Majumder</option>
                                    <option value="Dr.Jiwesh Thakur">Dr.Jiwesh Thakur</option>
                                    <option value="Dr.Runu Mukherjee">Dr.Runu Mukherjee</option>
                                    <option value="Dr.P.K.Dutta">Dr.P.K.Dutta</option>
                                    <option value="Dr.S.P.Singh">Dr.S.P.Singh</option>
                                    <option value="Dr.Biswarup Mukherjee">Dr.Biswarup Mukherjee</option>
                                    <option value="Dr.Subendu Dey">Dr.Subendu Dey</option>
                                    <option value="Dr.Sabyasachi Mukherjee">Dr.Sabyasachi Mukherjee</option>
                                    <option value="Dr.Kingshuk Karmakar">Dr.Kingshuk Karmakar</option>
                                    <option value="Dr.Sudarshana Sen Gupta">Dr.Sudarshana Sen Gupta</option>
                                    <option value="Dr.S.K.Mahapatra">Dr.S.K.Mahapatra</option>
                                    <option value="Dr.Nilotpaul Bhattacharjee">Dr.Nilotpaul Bhattacharjee</option>
                                    <option value="Dr.Premnath Dutta">Dr.Premnath Dutta</option>
                                    <option value="Dr.Piyush Agarwal">Dr.Piyush Agarwal</option>
                                    <option value="Dr.Manoj Kumar Sudrania">Dr.Manoj Kumar Sudrania</option>
                                    <option value="Dr.Ishfaq Ahmad Gilani">Dr.Ishfaq Ahmad Gilani</option>
                                    <option value="Dr.Indranil Mukherjee">Dr.Indranil Mukherjee</option>
                                    <option value="Dr.Bikram Roy">Dr.Bikram Roy</option>
                                    <option value="Dr.Rupam Sinha">Dr.Rupam Sinha</option>
                                    <option value="Dr.Sayantan Ghosh">Dr.Sayantan Ghosh</option>
                                    <option value="Dr.Shibashis Chatterjee">Dr.Shibashis Chatterjee</option>
                                    <option value="Dr.Sudesna Mondal">Dr.Sudesna Mondal</option>
                                    <option value="Dr.Rohan Bhattacharjee">Dr.Rohan Bhattacharjee</option>
                                    <option value="Dr.Soumen Kumar Dey">Dr.Soumen Kumar Dey</option>
                                    <option value="Dr.Lokesh Kumar">Dr.Lokesh Kumar</option>
                                    <option value="Dr.Ayan Chakroborty">Dr.Ayan Chakroborty</option>
                                    <option value="Dr.Pinki Kumari Jha">Dr.Pinki Kumari Jha</option>
                                    <option value="Dr.Utsa Senapati">Dr.Utsa Senapati</option>
                                    <option value="Dr.Bhaskardev Mukhopadhyay">Dr.Bhaskardev Mukhopadhyay</option>
                                    <option value="Dr.Nayan Ghosh">Dr.Nayan Ghosh</option>
                                </select>
                            </div>
                            <div class="col-12 col-sm-6">
                                <input type="text" class="form-control bg-light border-0" name="name" placeholder="Your Name" style="height: 55px;">
                            </div>
                            <div class="col-12 col-sm-6">
                                <input type="email" class="form-control bg-light border-0" name="email" placeholder="Your Email" style="height: 55px;">
                            </div>
                            <div class="col-12 col-sm-6">
                                <div class="date" id="date" data-target-input="nearest">
                                    <input type="date" name="appointment_date"
                                        class="form-control bg-light border-0 datetimepicker-input"
                                        placeholder="Date" data-target="#date" data-toggle="datetimepicker" style="height: 55px;">
                                </div>
                            </div>
                            <div class="col-12 col-sm-6">
                                <div class="time" id="time" data-target-input="nearest">
                                    <input type="time" name="appointment_time"
                                        class="form-control bg-light border-0 datetimepicker-input"
                                        placeholder="Time" style="height: 55px;">
                                </div>
                            </div>
                            <div class="col-12">
                                <button class="btn btn-primary w-100 py-3" type="submit" name="asubmit">Make An Appointment</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Appointment End -->